/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDBasicMenuUI;
import com.quantumdata.widgets.QDSeparator;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.border.Border;

public class QDMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private boolean m_mouseOver = false;
    private boolean m_smallBorder = false;

    public QDMenu() {
        this.initLook();
    }

    public QDMenu(String string) {
        super(string);
        this.initLook();
    }

    public QDMenu(Action action) {
        super(action);
        this.initLook();
    }

    public QDMenu(String string, boolean bl) {
        super(string, bl);
        this.initLook();
    }

    private void initLook() {
        this.setBackground(QDStdUI.getActionBackground());
        if (QDStdUI.g_menuStyle == 0) {
            this.setForeground(Color.black);
        }
        if (QDStdUI.g_menuStyle == 1) {
            this.setForeground(QDStdUI.getActionForeground());
        }
        this.getPopupMenu().setBackground(QDStdUI.getActionBackground());
        this.getPopupMenu().setBorder(BorderFactory.createLineBorder(QDStdUI.getActionBackground()));
        if (QDStdUI.g_useLargeMenus) {
            this.setFont(QDStdUI.getActionFont());
            this.setBorder(this.createItemBorder());
        }
        this.setUI(new QDBasicMenuUI());
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                QDMenu.this.m_mouseOver = true;
                QDMenu.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                QDMenu.this.m_mouseOver = false;
                QDMenu.this.repaint();
            }
        });
    }

    public void setSmallBorder(boolean bl) {
        this.m_smallBorder = bl;
        this.setBorder(this.createItemBorder());
    }

    private Border createItemBorder() {
        Border border = BorderFactory.createRaisedBevelBorder();
        if (this.m_smallBorder) {
            return border;
        }
        int n = QDStdUI.getActionInset();
        Border border2 = BorderFactory.createEmptyBorder(n, n, n, n);
        return BorderFactory.createCompoundBorder(border, border2);
    }

    public void paint(Graphics graphics) {
        if (QDStdUI.g_menuStyle == 0) {
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getButtonLight(), 0.0f, this.getHeight(), QDStdUI.getButtonDark());
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(paint);
            if (this.m_mouseOver && !this.isSelected()) {
                this.setForeground(QDStdUI.getFocusColor());
            } else {
                this.setForeground(Color.black);
            }
        }
        if (QDStdUI.g_menuStyle == 1) {
            graphics.setColor(QDStdUI.getActionBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.m_mouseOver && !this.isSelected()) {
                this.setForeground(QDStdUI.getFocusColor());
            } else {
                this.setForeground(QDStdUI.getActionForeground());
            }
        }
        super.paint(graphics);
    }

    public void addSeparator() {
        this.getPopupMenu().add(new QDSeparator());
    }
}

